#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C]
 -C  remove downloaded files
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done

if [ "$cleanup" = "true" ] ; then
    echo "Removing $PACKAGES_DIR/* ..."
    rm -rf $PACKAGES_DIR/*
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi


echo "Checking prerequisites:"
checkRPM wget

echo "Creating packages directory  ..."
mkdir -p $PACKAGES_DIR || exit 1

echo "Retrieving http://qmail.org/netqmail-$VERSION_NETQMAIL.tar.gz ..."
(cd $PACKAGES_DIR && wget http://qmail.org/netqmail-$VERSION_NETQMAIL.tar.gz) || exit 1

echo "Retrieving http://shupp.org/patches/netqmail-1.05-tls-smtpauth-20051423.patch ..."
(cd $PACKAGES_DIR && wget http://shupp.org/patches/netqmail-1.05-tls-smtpauth-20051423.patch) || exit 1

echo "Retrieving http://www.qmail.org/doublebounce-trim.patch ..."
(cd $PACKAGES_DIR && wget http://www.qmail.org/doublebounce-trim.patch) || exit 1

echo "Retrieving http://cr.yp.to/daemontools/daemontools-$VERSION_DAEMONTOOLS.tar.gz ..."
(cd $PACKAGES_DIR && wget http://cr.yp.to/daemontools/daemontools-$VERSION_DAEMONTOOLS.tar.gz) || exit 1

echo "Retrieving http://smarden.org/pape/djb/manpages/daemontools-$VERSION_DAEMONTOOLS-man.tar.gz ..."
(cd $PACKAGES_DIR && wget http://smarden.org/pape/djb/manpages/daemontools-$VERSION_DAEMONTOOLS-man.tar.gz) || exit 1

echo "Retrieving http://cr.yp.to/ucspi-tcp/ucspi-tcp-$VERSION_UCSPI_TCP.tar.gz ..."
(cd $PACKAGES_DIR && wget http://cr.yp.to/ucspi-tcp/ucspi-tcp-$VERSION_UCSPI_TCP.tar.gz) || exit 1

echo "Retrieving http://smarden.org/pape/djb/manpages/ucspi-tcp-$VERSION_UCSPI_TCP-man.tar.gz ..."
(cd $PACKAGES_DIR && wget http://smarden.org/pape/djb/manpages/ucspi-tcp-$VERSION_UCSPI_TCP-man.tar.gz) || exit 1

echo "Retrieving http://cr.yp.to/checkpwd/checkpassword-$VERSION_CHECKPASSWORD.tar.gz ..."
(cd $PACKAGES_DIR && wget http://cr.yp.to/checkpwd/checkpassword-$VERSION_CHECKPASSWORD.tar.gz) || exit 1

echo "Retrieving http://switch.dl.sourceforge.net/sourceforge/clamav/clamav-$VERSION_CLAMAV.tar.gz ..."
(cd $PACKAGES_DIR && wget http://switch.dl.sourceforge.net/sourceforge/clamav/clamav-$VERSION_CLAMAV.tar.gz) || exit 1

echo "Retrieving http://untroubled.org/bglibs/bglibs-$VERSION_BGLIBS.tar.gz ..."
(cd $PACKAGES_DIR && wget http://untroubled.org/bglibs/bglibs-$VERSION_BGLIBS.tar.gz) || exit 1

echo "Retrieving http://untroubled.org/qmail-qfilter/qmail-qfilter-$VERSION_QMAIL_QFILTER.tar.gz ..."
(cd $PACKAGES_DIR && wget http://untroubled.org/qmail-qfilter/qmail-qfilter-$VERSION_QMAIL_QFILTER.tar.gz) || exit 1

echo "Retrieving http://gd.tuwien.ac.at/db/mysql/Downloads/MySQL-4.1/mysql-$VERSION_MYSQL.tar.gz ..."
(cd $PACKAGES_DIR && wget http://gd.tuwien.ac.at/db/mysql/Downloads/MySQL-4.1/mysql-$VERSION_MYSQL.tar.gz) || exit 1

echo "Retrieving http://switch.dl.sourceforge.net/sourceforge/courier/courier-authlib-$VERSION_AUTHLIB.tar.bz2 ..."
(cd $PACKAGES_DIR && wget http://switch.dl.sourceforge.net/sourceforge/courier/courier-authlib-$VERSION_AUTHLIB.tar.bz2) || exit 1

echo "Retrieving http://switch.dl.sourceforge.net/sourceforge/courier/courier-imap-$VERSION_COURIERIMAP.tar.bz2 ..."
(cd $PACKAGES_DIR && wget http://switch.dl.sourceforge.net/sourceforge/courier/courier-imap-$VERSION_COURIERIMAP.tar.bz2) || exit 1

echo "Retrieving http://www.arda.homeunix.net/store/courierpasswd-$VERSION_COURIERPASSWD.tar.gz ..."
(cd $PACKAGES_DIR && wget http://www.arda.homeunix.net/store/courierpasswd-$VERSION_COURIERPASSWD.tar.gz) || exit 1

echo "Retrieving http://www.fehcom.de/qmail/auth/base64-$VERSION_BASE64.tar.gz ..."
(cd $PACKAGES_DIR && wget http://www.fehcom.de/qmail/auth/base64-$VERSION_BASE64.tar.gz) || exit 1

echo "Retrieving http://switch.dl.sourceforge.net/sourceforge/courier/maildrop-$VERSION_MAILDROP.tar.bz2 ..."
(cd $PACKAGES_DIR && wget http://switch.dl.sourceforge.net/sourceforge/courier/maildrop-$VERSION_MAILDROP.tar.bz2) || exit 1

echo ""
echo "Download completed"
