#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done

if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Running /etc/init.d/mysql.server stop ..."
    /etc/init.d/mysql.server stop
    sleep 3
    echo "Killing all mysqld processes ..."
    killall mysqld
    sleep 3
    echo "Removing mysql group and user ..."
    userdel -r mysql
    groupdel mysql
    echo "Removing /usr/local/mysql/ ..."
    rm -rf /usr/local/mysql/
    echo "Removing /etc/my.cnf ..."
    rm -f /etc/my.cnf
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi

checkRPM termcap
checkRPM ncurses-devel
checkRPM gcc-c++

#############################
# Install MYSQL from source #
#############################
# (some shared libs required by courier-authlib do not come with the binary distribution)
echo "INSTALLING MYSQL FROM SOURCE"

# the -r option is non-standard
echo "Adding system group mysql ..."
groupadd -r mysql || exit 1

echo "Adding system account mysql ..."
useradd -r -g mysql mysql || exit 1

echo "Extracting mysql ..."
(cd $EXTRACT_DIR && tar zxf $PACKAGES_DIR/mysql-$VERSION_MYSQL.tar.gz) || exit 1

echo "Running ./configure for mysql ..."
(cd $EXTRACT_DIR/mysql-$VERSION_MYSQL &&
./configure \
--prefix=/usr/local/mysql \
--localstatedir=/data/mysql \
--enable-thread-safe-client \
--with-low-memory \
--with-extra-charsets=complex) || exit 1

echo "Running make for mysql ..."
(cd $EXTRACT_DIR/mysql-$VERSION_MYSQL && make) || exit 1

echo "Running make install for mysql ..."
(cd $EXTRACT_DIR/mysql-$VERSION_MYSQL && make install) || exit 1

echo "Copying my-medium.cnf to /etc/my.cnf ..."
cp $EXTRACT_DIR/mysql-$VERSION_MYSQL/support-files/my-medium.cnf /etc/my.cnf || exit 1

# as we do not do any replication comment out log-bin
# vi /etc/my.cnf

echo ""
echo "CONGRATULATIONS! The MySQL successfully installed."

