#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-U]
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done

if [ "$uninstall" = "true" ] ; then
    echo "Running /etc/init.d/mysql.server stop ..."
    /etc/init.d/mysql.server stop
    sleep 3
    echo "Killing all mysqld processes ..."
    killall mysqld
    sleep 3
    echo "Removing /data/mysql ..."
    rm -rf /data/mysql
    echo "Removing /home/*/.my.cnf and /root/.my.cnf ..."
    rm -f /home/*/.my.cnf /root/.my.cnf
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi

echo "Checking correct configuration ..."
if [ "$MYSQL_ROOT_PWD" = "" ] ; then
    echo "ERROR: Edit install.conf and set MYSQL_ROOT_PWD!"
    exit 1
fi

if [ "$MYSQL_MAILADMIN_PWD" = "" ] ; then
    echo "ERROR: Edit install.conf and set MYSQL_MAILADMIN_PWD!"
    exit 1
fi

if [ "$MYSQL_MAILUSERS_PWD" = "" ] ; then
    echo "ERROR: Edit install.conf and set MYSQL_MAILUSERS_PWD!"
    exit 1
fi

echo "Creating /data/mysql ..."
mkdir -p /data/mysql || exit 1

echo "Running mysql_install_db ..."
/usr/local/mysql/bin/mysql_install_db --user=mysql || exit 1

echo "Setting ownership and permissions for /usr/local/mysql & /data/mysql"
chown -R root /usr/local/mysql || exit 1
chgrp -R mysql /usr/local/mysql || exit 1
chown -R mysql:mysql /data/mysql || exit 1

# make sure authlib will find the mysql shared libs
echo "Adding /usr/local/mysql/lib/mysql to /etc/ld.so.conf ..."
echo /usr/local/mysql/lib/mysql >> /etc/ld.so.conf || exit 1

echo "Running ldconfig ..."
ldconfig || exit 1

echo "Running ldconfig -v | grep mysql ..."
ldconfig -v | grep mysql
echo -n "Confirm that the mysql libs where found by pressing ENTER:"
read in

# we want mysql to start on boot
echo "Creating run level startup scripts ..."
cp /usr/local/mysql/share/mysql/mysql.server /etc/init.d/
# should be started before courier-imap & courier-pop
rm -f /etc/rc.d/rc3.d/S12mysql.server
ln -s /etc/init.d/mysql.server /etc/rc.d/rc3.d/S12mysql.server
# should be killed after courier-imap & courier-pop
rm -f /etc/rc.d/rc3.d/K08mysql.server
ln -s /etc/init.d/mysql.server /etc/rc.d/rc3.d/K08mysql.server

# Add the following lines to /etc/man.config or /etc/manpath.config (whichever exists)
# MANDATORY_MANPATH /usr/local/mysql/man
# MANPATH_MAP   /usr/local/mysql/bin       /usr/local/mysql/man
[ -f /etc/man.config ] && FILE=/etc/man.config
[ -f /etc/manpath.config ] && FILE=/etc/manpath.config
if [ "$FILE" != "" ] ; then
    echo "MANDATORY_MANPATH /usr/local/mysql/man" >> $FILE
    echo "MANPATH_MAP   /usr/local/mysql/bin       /usr/local/mysql/man" >> $FILE
else
    echo "WARNING: could not find /etc/man.config or /etc/manpath.config!"
fi

# get it up and running
echo "Starting MySQL by running /etc/init.d/mysql.server start ..."
/etc/init.d/mysql.server start

# check error log for erros
sleep 5
echo "Showing last ten lines of error log ..."
tail /data/mysql/`hostname`.err

# If you ever want to debug mysql call mysqld_safe from
# /etc/init.d/mysql.server with an --log=/tmp/mysql.log option.

# verify that mysqld is functional
echo "Starting mysql client ... "
echo "show databases" | /usr/local/mysql/bin/mysql > /dev/null || exit 1

# cleaning up
echo "Deleting test account and test database ..."
echo "delete from db where Db LIKE '%test%'" | /usr/local/mysql/bin/mysql mysql
echo "delete from user where User=''" | /usr/local/mysql/bin/mysql mysql
echo "drop database test" | /usr/local/mysql/bin/mysql mysql

# use something else than "test"!
echo "Setting mysql root password to MYSQL_ROOT_PWD config option ..."
echo "UPDATE user SET Password=PASSWORD('$MYSQL_ROOT_PWD') WHERE User='root'" | \
  /usr/local/mysql/bin/mysql mysql

echo "Flushing privileges ..."
echo "FLUSH PRIVILEGES" | \
  /usr/local/mysql/bin/mysql mysql

# /usr/local/mysql/bin/mysqladmin -u root password 'test'
#/usr/local/mysql/bin/mysqladmin -u root -h `hostname` password 'test'
# if this doesn't work run the SQL commands
# mysql> use mysql;
# mysql> update user set Password=PASSWORD('test') where User='root' AND Password='';
# mysql> FLUSH PRIVILEGES;

#
# remove the test db and empty usernames
# mysql> use mysql
# mysql> delete from db where Db LIKE '%test%';
# mysql> delete from user where User='';
# mysql> drop database test;
#

# to add a .my.cnf file for mailadmin and root so that they do
# not have to enter their mysql password
# This will be really handy when working with the mailusers package.
echo "Installing ~/.my.cnf for mailadmin and root ..."
sed s/MYSQL_MAILADMIN_PWD/$MYSQL_MAILADMIN_PWD/ $SCRIPTS_DIR/home_mailadmin_mycnf > /home/mailadmin/.my.cnf || exit 1
sed s/MYSQL_MAILADMIN_PWD/$MYSQL_ROOT_PWD/ $SCRIPTS_DIR/home_mailadmin_mycnf > /root/.my.cnf || exit 1
echo "Changing ownership and permissions for ~mailadmin/.my.cnf ..."
chown mailadmin:mailadmin /home/mailadmin/.my.cnf || exit 1
chmod 600 /home/mailadmin/.my.cnf /root/.my.cnf || exit 1

# edit the password to use for the mysql accounts mailusers and mailadmin
#vi $SCRIPTS_DIR/mailusers.sql

# use the following command to set up
# - the database mailuses
# - the tables passwd, sa_domainpref and sa_userpref
# - the accounts mailadmin and mailusers (for use with authlib - and
#   therefore with only SELECT privileges)
# - virtual_domains and aliases
# - sync_mailuser, sync_maildomain, sync_mailinglist and sync_mailalias
# - phpmailadmin_auth & phpmailadmin_permissions
echo "Execute SQL DDL from $SCRIPTS_DIR/mailusers.sql ..."
cat $SCRIPTS_DIR/mailusers.sql | \
    sed s/MYSQL_MAILADMIN_PWD/$MYSQL_MAILADMIN_PWD/ | \
    sed s/MYSQL_MAILUSERS_PWD/$MYSQL_MAILUSERS_PWD/ | \
    /usr/local/mysql/bin/mysql -u root mysql || exit 1


## change the password for mailadmin
#vi /home/mailadmin/.my.cnf
## change the password for root
#vi /root/.my.cnf


echo "Adding /usr/local/mysql/bin to PATH ..."
if [ "`grep /usr/local/mysql /etc/profile.d/paths.sh`" = "" ] ; then
    echo "PATH=\$PATH:/usr/local/mysql/bin" >> /etc/profile.d/paths.sh || \
      echo "Could not add /usr/local/mysql/bin to PATH; you'll have to do that yourself!"
    export PATH=$PATH:/usr/local/mysql/bin
else
    echo "is already in /etc/profile.d/paths.sh: no action needed"
fi

echo ""
echo "CONGRATULATIONS! The MySQL database was successfully configured."

