#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done


if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Stopping courier-imap ..."
    /etc/init.d/courier-imap stop

    echo "Stopping courier-pop3 ..."
    /etc/init.d/courier-pop3 stop

    echo "Stopping courier-imaps ..."
    /etc/init.d/courier-imaps stop

    echo "Stoping courier-pop3s ..."
    /etc/init.d/courier-pop3s stop

    sleep 2

    echo "Removing /usr/lib/courier-imap/ ..."
    rm -rf /usr/lib/courier-imap/

    echo "Removing run level startup scripts ..."
    rm -f /etc/init.d/courier-*
    rm -f /etc/rc.d/rc3.d/*courier-imap*
    rm -f /etc/rc.d/rc3.d/*courier-pop3*
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi

### PREREQUISITES ###
echo "Checking prerequisites:"
checkRPM gamin
checkRPM sudo
checkRPMAlternative gdbm-devel db-devel

echo "Creating internal directories ..."
mkdir -p $PACKAGES_DIR || exit 1
mkdir -p $EXTRACT_DIR || exit 1

################
# COURIER-IMAP #
################
# also includes the POP server!

echo "Creating extract directory ..."
mkdir -p $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP || exit 1
echo -n "Please enter the name of the regular user that should be used to complile courier-imap:"
while true;
do
    read in;
    if [ "$in" = "root" ] ; then
        echo -n "Please enter another user than root:"
        continue
    fi
    echo "Trying to sudo .."
    sudo -u $in pwd > /dev/null;ret=$?
    if [ $ret -eq 0 ] ; then
        echo OK
        REG_USER="$in"
        break
    else
        echo -n "Sudo failed with a return code of $?! Please try again:"
    fi
done

if [ "$REG_USER" = "" ] ; then
    echo "ERROR: could not read in username."
    exit 1
fi

echo "Changing ownership for extract directory ..."
chown $REG_USER $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP || exit 1

echo "Extracting courier-imap ..."
(cd $EXTRACT_DIR && sudo -u $REG_USER tar jxf $PACKAGES_DIR/courier-imap-$VERSION_COURIERIMAP.tar.bz2) || exit 1

# --with-redhat for fedora
echo "Running ./configure for courier-imap ..."
(cd $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP && sudo -u $REG_USER ./configure)  || exit 1

echo "Running make for courier-imap ..."
(cd $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP && sudo -u $REG_USER make) || exit 1

# Note: if the --enable-workarounds-for-imap-client-bugs
# option was used, make check will FAIL.
echo "Running make check for courier-imap ..."
(cd $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP && sudo -u $REG_USER make check) || exit 1

# use ``make install'' if ``make install-strip'' fails
echo "Running make install-strip for courier-imap ..."
(cd $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP && make install-strip) || exit 1

echo "Running make install-configure for courier-imap ..."
(cd $EXTRACT_DIR/courier-imap-$VERSION_COURIERIMAP && make install-configure) || exit 1

# set MAXDAEMONS=200
# set MAXPERIP=20
# set IMAPDSTART=YES
echo "Applying patch courier-imapd-config.patch ..."
(cd /usr/lib/courier-imap/etc/ && patch < $PATCHES_DIR/courier-imapd-config.patch) || exit 1

# set MAXDAEMONS=200
# set MAXPERIP=20
# set POP3DSTART=YES
echo "Applying patch courier-pop3d-config.patch ..."
(cd /usr/lib/courier-imap/etc/ && patch < $PATCHES_DIR/courier-pop3d-config.patch) || exit 1

# Note: to create certificates singed by your own self-signed CA follow the
# steps outlined in $HOME_DIR/HOW_TO_MAKE_OWN_CA.txt and do not run
# these commands.
echo "Creating certificate for Courier-IMAP ..."
(cd /usr/lib/courier-imap/share && ./mkimapdcert) || exit 1

echo "Creating certificate for Courier-POP3 ..."
(cd /usr/lib/courier-imap/share && ./mkpop3dcert) || exit 1


echo "Installing run level startup scripts ..."
rm -f /etc/init.d/courier-imap
rm -f /etc/init.d/courier-pop3
rm -f /etc/init.d/courier-imaps
rm -f /etc/init.d/courier-pop3s
cp /usr/lib/courier-imap/libexec/imapd.rc /etc/init.d/courier-imap || exit 1
cp /usr/lib/courier-imap/libexec/pop3d.rc /etc/init.d/courier-pop3 || exit 1
cp /usr/lib/courier-imap/libexec/imapd-ssl.rc /etc/init.d/courier-imaps || exit 1
cp /usr/lib/courier-imap/libexec/pop3d-ssl.rc /etc/init.d/courier-pop3s || exit 1

echo "Changing ownership and permissions for run level startup scripts ..."
chmod 755 /etc/init.d/courier-imap* || exit 1
chmod 755 /etc/init.d/courier-pop3* || exit 1
chown root:root /etc/init.d/courier-imap* || exit 1
chown root:root /etc/init.d/courier-pop3* || exit 1

echo "Linking startup scripts into /etc/rc.d/rc3.d ..."
rm -f /etc/rc.d/rc3.d/*courier-imap*
rm -f /etc/rc.d/rc3.d/*courier-pop3*

# should be started after mysql and authdaemond
ln -s /etc/init.d/courier-imap /etc/rc.d/rc3.d/S14courier-imap || exit 1
ln -s /etc/init.d/courier-pop3 /etc/rc.d/rc3.d/S14courier-pop3 || exit 1
ln -s /etc/init.d/courier-imaps /etc/rc.d/rc3.d/S14courier-imaps || exit 1
ln -s /etc/init.d/courier-pop3s /etc/rc.d/rc3.d/S14courier-pop3s || exit 1
# should be killed before mysql and authdaemond
ln -s /etc/init.d/courier-imap /etc/rc.d/rc3.d/K06courier-imap || exit 1
ln -s /etc/init.d/courier-pop3 /etc/rc.d/rc3.d/K06courier-pop3 || exit 1
ln -s /etc/init.d/courier-imaps /etc/rc.d/rc3.d/K06courier-imaps || exit 1
ln -s /etc/init.d/courier-pop3s /etc/rc.d/rc3.d/K06courier-pop3s || exit 1

echo "Starting courier-imap ..."
/etc/init.d/courier-imap start || exit 1

echo "Starting courier-pop3 ..."
/etc/init.d/courier-pop3 start || exit 1

echo "Starting courier-imaps ..."
/etc/init.d/courier-imaps start || exit 1

echo "Starting courier-pop3s ..."
/etc/init.d/courier-pop3s start || exit 1

echo "Please test the IMAP connection now by doing the follogin:"
echo "telnet localhost 143"
echo "> c1 login <someuser> <somepassword>"
echo "> c2 select INBOX"
echo "> c3 logout"
echo "Note: you might first have to run the following command as <someuser>"
echo " /usr/lib/courier-imap/bin/maildirmake ~/Maildir"
echo -n "Confirm a functioning IMAP connection by pressing ENTER:"
read in

echo "Please test the POP3 connection now by doing the follogin:"
echo "telnet localhost 110"
echo "> user <someuser>"
echo "> pass <somepassword>"
echo "> list"
echo "> quit"
echo -n "Confirm a functioning POP3 connection by pressing ENTER:"
read in

# Add the following lines to /etc/man.config or /etc/manpath.config (whichever exists)
# MANDATORY_MANPATH /usr/lib/courier-imap/man
# MANPATH_MAP   /usr/lib/courier-imap/bin       /usr/lib/courier-imap/man
# MANPATH_MAP   /usr/lib/courier-imap/sbin      /usr/lib/courier-imap/man
echo "Updating MANPATH ..."
[ -f /etc/man.config ] && FILE=/etc/man.config
[ -f /etc/manpath.config ] && FILE=/etc/manpath.config
if [ "$FILE" != "" ] ; then
    echo "MANDATORY_MANPATH /usr/lib/courier-imap/man" >> $FILE
    echo "MANPATH_MAP   /usr/lib/courier-imap/bin  /usr/lib/courier-imap/man" >> $FILE
    echo "MANPATH_MAP   /usr/lib/courier-imap/sbin /usr/lib/courier-imap/man" >> $FILE
else
    echo "WARNING: could not find /etc/man.config or /etc/manpath.config!"
fi

# make sure mailusers can read the authdaemon socket file
echo "Checking if the account mailusers can read /usr/local/var/spool/authdaemon/socket ..."
sudo -u mailusers ls /usr/local/var/spool/authdaemon/socket > /dev/null || exit 1

echo ""
echo "CONGRATULATIONS! Courier-IMAP & Courier-POP3 were successfully installed."

# END
