#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done


if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Removing /var/qmail/bin/courierpasswd ..."
    rm -rf /var/qmail/bin/courierpasswd
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi


echo "Creating internal directories ..."
mkdir -p $PACKAGES_DIR || exit 1
mkdir -p $EXTRACT_DIR || exit 1


#############################################################
# COURIERPASSWD - AUTHLIB COMPATIBLE VERSION OF checkpasswd #
#############################################################
# we will use courierpasswd for SMTP-Auth

# we use courierpasswd here for the following reasons:
# - most people that use qmail with Courier-IMAP do so
# - it works with authlib and Courier-IMAP 4.0
echo "Extracting courierpasswd ..."
(cd $EXTRACT_DIR && tar zxvf $PACKAGES_DIR/courierpasswd-$VERSION_COURIERPASSWD.tar.gz) || exit 1

echo "Running ./configure for courierpasswd ..."
(cd $EXTRACT_DIR/courierpasswd-$VERSION_COURIERPASSWD && ./configure) || exit 1

echo "Running make for courierpasswd ..."
(cd $EXTRACT_DIR/courierpasswd-$VERSION_COURIERPASSWD && make) || exit 1

echo "Running make install for courierpasswd ..."
(cd $EXTRACT_DIR/courierpasswd-$VERSION_COURIERPASSWD && make install) || exit 1

echo "Now test it as root like this:"
echo 'echo -e "username\0password\0" | courierpasswd --stderr --stdin --verbose'
echo -n "Confirm that it worked by pressing enter:"
read in

# we do not want courierpasswd to be SUID root; plus: only qmaild needs to run it
# therefore we put into a directory readable only by qmaild and we make it SUID mailusers.
# mailusers is enough because that's the one that has exclusive acessess to authdaemon's
# socket file.
echo "Creating /var/qmail/bin/courierpasswd/ ..."
mkdir -p /var/qmail/bin/courierpasswd || exit 1

echo "Setting permissions of /var/qmail/bin/courierpasswd/ to 700 ..."
chmod 700 /var/qmail/bin/courierpasswd || exit 1

echo "Making qmaild own /var/qmail/bin/courierpasswd/ ..."
chown qmaild:root /var/qmail/bin/courierpasswd || exit 1

echo "Moving courierpasswd from /usr/local/sbin to /var/qmail/bin/courierpasswd/ ..."
mv -i /usr/local/sbin/courierpasswd /var/qmail/bin/courierpasswd/ || exit 1

echo "Making mailusers own /var/qmail/bin/courierpasswd/courierpasswd ..."
chown mailusers:root /var/qmail/bin/courierpasswd/courierpasswd || exit 1

echo "Setting SUID-bit (permissions of 4511) for /var/qmail/bin/courierpasswd/courierpasswd ..."
chmod 4511 /var/qmail/bin/courierpasswd/courierpasswd || exit 1

echo "Now test it again as root like this:"
echo 'echo -e "username\0password\0" | /var/qmail/bin/courierpasswd/courierpasswd --stderr --stdin --verbose'
echo -n "Confirm that it worked by pressing enter:"
read in

# test it as qmaild who will really be only one running courierpasswd
echo "Test it again!"
echo "This time we want to know if the user qmaild (who will really be running it) can do it:"
echo 'echo -e "username\0password\0" | sudo -u qmaild /var/qmail/bin/courierpasswd/courierpasswd --stderr --stdin --verbose'
echo -n "Confirm that it worked by pressing enter:"
read in

echo ""
echo "CONGRATULATIONS! courierpasswd was successfully installed."

# END
