#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done


if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Removing /usr/local/bin/base64 ..."
    rm -rf /usr/local/bin/base64

    echo "Removing /usr/local/man/man1/base64.1 ..."
    rm -rf /usr/local/man/man1/base64.1
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi


##########
# BASE64 #
##########
## install a Base 64 converter for testing
echo "INSTALLING BASE64"

echo "Extracting base64 ..."
(cd $EXTRACT_DIR && tar xzf $PACKAGES_DIR/base64-$VERSION_BASE64.tar.gz) || exit 1

echo "Running ./configure for base64 ..."
(cd $EXTRACT_DIR/base64-$VERSION_BASE64 && ./configure) || exit 1

echo "Running make for base64 ..."
(cd $EXTRACT_DIR/base64-$VERSION_BASE64 && make) || exit 1

echo "Running make check for base64 ..."
(cd $EXTRACT_DIR/base64-$VERSION_BASE64 && make check) || exit 1

echo "Running make wringer for base64 ..."
(cd $EXTRACT_DIR/base64-$VERSION_BASE64 && make wringer) || exit 1

echo "Running make install for base64 ..."
(cd $EXTRACT_DIR/base64-$VERSION_BASE64 && make install) || exit 1

echo ""
echo "CONGRATULATIONS! base64 was successfully installed."
