#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done


if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Removing /usr/local/bin/maildrop ..."
    rm -f /usr/local/bin/maildrop
    echo "Setting default delivery to './Maildir/' ..."
    echo "./Maildir/" > /var/qmail/control/defaultdelivery || exit 1
    echo "Running qmailctl reload ..."
    qmailctl reload
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi

checkRPM pcre
checkRPM pcre-devel

####################
# COURIER MAILDROP #
####################
# resources
# - http://www.courier-mta.org/?maildrop.html
# - http://www.courier-mta.org/?maildropfilter.html

echo "Extracting maildrop ..."
(cd $EXTRACT_DIR && tar jxf $PACKAGES_DIR/maildrop-$VERSION_MAILDROP.tar.bz2) || exit 1

echo "Running ./configure for maildrop ..."
(cd $EXTRACT_DIR/maildrop-$VERSION_MAILDROP && ./configure \
 --without-db \
 --enable-syslog=1 \
 --enable-maildirquota) || exit 1

# - change DEFAULT_DEF to: #define DEFAULT_DEF ``./Maildir''
# - add this line: #define MAILBOX_MODE "0600"
# - change TRUSTED_USERS to: #define TRUSTED_USERS ``root mail mailusers qmaild''
echo "Applying patch maildrop_maildrop-config.h.patch ..."
(cd $EXTRACT_DIR/maildrop-$VERSION_MAILDROP/maildrop && \
  patch < $PATCHES_DIR/maildrop_maildrop-config.h.patch) || exit 1

echo "Running make for maildrop ..."
(cd $EXTRACT_DIR/maildrop-$VERSION_MAILDROP && make) || exit 1

echo "Running make install-strip for maildrop ..."
(cd $EXTRACT_DIR/maildrop-$VERSION_MAILDROP && make install-strip) || exit 1

echo "Running make install-man for maildrop ..."
(cd $EXTRACT_DIR/maildrop-$VERSION_MAILDROP && make install-man) || exit 1

# verify that maildrop was not installed SUID
# (qmail will switch to the UID required before running qmail-lspawn)
echo "Displying permissions for /usr/local/bin/maildrop ..."
ls -l /usr/local/bin/maildrop || exit 1
echo -n "Confirm that maildrop was not installed with SUID by pressing ENTER:"
read in

echo "Creating /home/mailusers/domains ..."
mkdir -p /home/mailusers/domains || exit 1

echo "Setting permissions to 700 ..."
chmod 700 /home/mailusers /home/mailusers/domains || exit 1

echo "Setting owner and group to mailusers ..."
chown mailusers:mailusers /home/mailusers /home/mailusers/domains || exit 1

echo "Installing /home/mailusers/.qmail-maildrop-virtual ..."
cp $SCRIPTS_DIR/home_mailusers_.qmail-maildrop-virtual \
  ~mailusers/.qmail-maildrop-virtual || exit 1

echo "Setting permissions for /home/mailusers/.qmail-maildrop-virtual to 0600 ..."
chmod 600 ~mailusers/.qmail-maildrop-virtual || exit 1

echo "Setting owner and group ..."
chown mailusers:mailusers ~mailusers/.qmail-maildrop-virtual || exit 1

echo "Setting default delivery to maildrop ..."
echo '|/usr/local/bin/maildrop' > /var/qmail/control/defaultdelivery || exit 1

echo "Running qmailctl reload ..."
qmailctl reload

echo ""
echo "CONGRATULATIONS! maildrop was successfully installed."

# END
