#!/bin/bash

export HOME_DIR=`(cd $(dirname $0); pwd)`
. $HOME_DIR/common.sh || exit 1

printUsage()
{
cat >&1 <<END
Usage:
 $0 [-C] [-U]
 -C  remove extraced files
 -U  uninstall *everything*; know what you are doing!
END
}

while getopts ":CU" opt; do
    case $opt in
        C ) cleanup=true;;
        U ) uninstall=true;;
        ? ) printUsage
            exit 1 ;;
    esac
done


if [ "$cleanup" = "true" ] ; then
    echo "Removing $EXTRACT_DIR/* ..."
    rm -rf $EXTRACT_DIR/*
fi

if [ "$uninstall" = "true" ] ; then
    echo "Removing temporary files ..."
    rm -f $TMP_DIR/nonspam.out $TMP_DIR/spam.out
    echo "Running spamdctl stop ..."
    spamdctl stop
    sleep 3
    echo "Removing /service/spamd ..."
    rm -f /service/spamd
    echo "Removing spamd user and group ..."
    userdel spamd
    groupdel spamd
    echo "Removing /var/spamd ..."
    rm -rf /var/spamd
    echo "Removing /var/log/spamd ..."
    rm -rf /var/log/spamd
    echo "Removing /etc/maildroprc ..."
    rm -f /etc/maildroprc
    
fi

if [ "$uninstall" = "true" -o "$cleanup" = "true" ] ; then
    exit 0
fi

echo "Checking prerequisites ..."
checkRPM openssl-devel
checkRPM unzip
#checkRPM elinks
#checkRPM lynx
#checkRPM unzip
#checkRPM perl-libwww-perl
#checkRPM perl-HTML-Parser
#checkRPM perl-Net-DNS
#checkRPM perl-Net-IP
#checkRPM perl-Digest-HMAC
#checkRPM perl-Archive-Tar
#checkRPM perl-IO-Socket-SSL
#checkRPMAlternative ncftpget ncftp

cat - <<END
Run 'perl -MCPAN -e shell' and then 'install <package>'
for all of the following packages:
LWP::UserAgent
Digest::SHA
Storable
MIME::Base64
HTML::Parser
DB_File
Net::DNS
Net::SMTP
Mail::SPF::Query
IP::Country
IP::Country::Fast
Net::Ident
IO::Socket::INET6
IO::Socket::SSL
DBI
DBD::mysql
HTTP::Date
Archive::Tar
IO::Zlib
Time::HiRes
Mail::SpamAssassin

END

echo -n "Press ENTER when done:"
read in

echo "Creating temporary directory ..."
mkdir -p $TMP_DIR || exit 1


echo "Testing sample non-spam ..."
spamassassin -t < $TESTS_DIR/sample-nonspam.txt > $TMP_DIR/nonspam.out || exit 1
if [ "`grep 'X-Spam-Status: Yes' $TMP_DIR/nonspam.out`" != "" ] ; then
    echo -n "It seems we have a false positive here: check $TMP_DIR/nonspam.out and press ENTER when done."
    read in
fi

echo "Testing sample spam ..."
spamassassin -t < $TESTS_DIR/sample-spam.txt > $TMP_DIR/spam.out || exit 1
if [ "`grep 'X-Spam-Status: Yes' $TMP_DIR/spam.out`" = "" ] ; then
    echo -n "It seems we have a false negative here: check $TMP_DIR/spam.out and press ENTER when done."
    read in
fi

rm -f $TMP_DIR/nonspam.out $TMP_DIR/spam.out

# to view the config man page you would run
# man Mail::SpamAssassin::Conf


###########################
# SPAMD UNDER DAEMONTOOLS #
###########################

# spamd will run as user spamd
# the -r option is non-standard but works under fedora and suse
echo "Adding spamd group ..."
groupadd -r spamd || exit 1

echo "Adding spamd user ..."
useradd -r -g spamd -s /bin/false -d /var/spamd spamd || exit 1

## no razor for now
# mkdir -p /var/spamd/.razor
# chown spamd:spamd /var/spamd/.razor
# export HOME=/var/spamd
# sudo -u spamd razor-admin -create
# sudo -u spamd razor-admin -register     # try multiple times if it fails
# export HOME=/root

echo "Creating /var/spamd/supervise/spamd/log ..."
mkdir -p /var/spamd/supervise/spamd/log || exit 1

echo "Creating /var/log/spamd ..."
mkdir -p /var/log/spamd || exit 1

echo "Changing ownership of /var/log/spamd to qmaill ..."
chown qmaill /var/log/spamd || exit 1

echo "Installing /var/spamd/supervise/spamd/run ..."
cp $SCRIPTS_DIR/var_spamd_supervise_spamd_run \
  /var/spamd/supervise/spamd/run || exit 1

echo "Installing /var/spamd/supervise/spamd/log/run ..."
cp $SCRIPTS_DIR/var_spamd_supervise_spamd_log_run \
  /var/spamd/supervise/spamd/log/run || exit 1
  
echo "Changing permissions to 755 for /var/spamd/supervise/spamd/run ..."
chmod 755 /var/spamd/supervise/spamd/run || exit 1

echo "Changing permissions to 755 for /var/spamd/supervise/spamd/log/run ..."
chmod 755 /var/spamd/supervise/spamd/log/run || exit 1

echo "Creating /var/spamd/bin ..."
mkdir -p /var/spamd/bin || exit 1

echo "Installing /var/spamd/bin/spamdctl ..."
cp $SCRIPTS_DIR/var_spamd_bin_spamdctl \
  /var/spamd/bin/spamdctl || exit 1

echo "Setting permissions to 755 for /var/spamd/bin/spamdctl ..."
chmod 755 /var/spamd/bin/spamdctl || exit 1

rm -f /usr/local/bin/spamdctl
echo "Linking /var/spamd/bin/spamdctl into /usr/local/bin ..."
ln -s /var/spamd/bin/spamdctl /usr/local/bin

echo "Creating /var/spamd/control ..."
mkdir -p /var/spamd/control || exit 1

# set the memory limit of spamd: 100MB - just to keep it from running away
echo $SPAMD_MEMORYLIMIT > /var/spamd/control/spamdmemorylimit

# set maximum number of spamd child processes; 5 is spamd's interal default
echo $SPAMD_MAXCHILDREN > /var/spamd/control/spamdmaxchildren

# set the maximum multilog log file size in bytes; if the logfile is bigger than that it will be rotated
echo $SPAMD_MULTILOGSIZE > /var/spamd/control/multilogsize

# set the maximum number of multilog log files to keep; old log files will be deleted
echo $SPAMD_MULTILOGNUM > /var/spamd/control/multilognum

# least privilege
echo "Setting permissions to 700 for /var/spamd/control ..."
chmod 700 /var/spamd/control || exit 1

echo "Setting permissions to 600 for /var/spamd/control/* ..."
chmod 600 /var/spamd/control/* || exit 1

rm -f /service/spamd
echo "Linking /var/spamd/supervise/spamd into /service ..."
ln -s /var/spamd/supervise/spamd /service || exit 1

echo "Wating 10 seconds for spamd to start ..."
sleep 10

# verify startup
# verify successful startup
echo "Please verify successful startup (output of 'spamdctl stat' follows):"
spamdctl stat
echo -n "Hit ENTER to confirm a successful startup:"
read in;

# check logs
echo "Viewing last 20 lines of /var/log/spamd/current ..."
tail -30 /var/log/spamd/current || exit 1
echo -n "Hit ENTER to confirm that the logs look fine:"
read in

echo "Testing sample non-spam via spamc ..."
spamc -U /tmp/spamd.sock < $TESTS_DIR/sample-nonspam.txt > $TMP_DIR/nonspam.out || exit 1
if [ "`grep 'X-Spam-Status: Yes' $TMP_DIR/nonspam.out`" != "" ] ; then
    echo "It seems we have a false positive here: check $TMP_DIR/nonspam.out and press ENTER when done."
    read in
fi

echo "Testing sample spam via spamc ..."
spamc -U /tmp/spamd.sock < $TESTS_DIR/sample-spam.txt > $TMP_DIR/spam.out || exit 1
if [ "`grep 'X-Spam-Status: Yes' $TMP_DIR/spam.out`" = "" ] ; then
    echo "It seems we have a false negative here: check $TMP_DIR/spam.out and press ENTER when done."
    read in
fi

rm -f $TMP_DIR/nonspam.out $TMP_DIR/spam.out


# INSTALL THE MAILDROPRC file
# if has the following features:
# - only messages smaller than 256 KB are fed into spamc
# - if the header X-Spam-Move-Mail is set (which can be
#   done using the domain/user settings in mysql), the
#   mail is moved to the sub foler "Spam".
#   Please note that this means that it will not show up
#   when connected via POP3.
# reference:
# - http://www.ladse.de/index.php/Installation:FreeBSD:Maildrop
echo "Installing /etc/maildroprc ..."
cp $SCRIPTS_DIR/etc_maildroprc /etc/maildroprc


echo "Sending spample non-spam to user root ..."
cat $TESTS_DIR/sample-nonspam.txt | mail root

echo "Sending sample spam to user root ..."
cat $TESTS_DIR/sample-spam.txt | mail root

echo "Go and check the mail for root. Hit ENTER to confirm that you recieved"
echo -n "a spam and a non-spam mail:"
read in


##########################################
# AUTO WHITELISTING & BAYESIAN FILTERING #
##########################################
# we will use site-wide auto whitelisting and no bayes database
echo "Now configuring site-wide auto whitelisting:"

echo "Creating /etc/mail/spamassassin/auto-whitelist ..."
mkdir -p /etc/mail/spamassassin/auto-whitelist || exit 1

echo "Setting ownership of /etc/mail/spamassassin/auto-whitelist to spamd:spamd ..."
chown -R spamd:spamd /etc/mail/spamassassin/auto-whitelist || exit 1

echo "Setting permissions for /etc/mail/spamassassin/auto-whitelist to 700 ..."
chmod 700 /etc/mail/spamassassin/auto-whitelist || exit 1

echo "Setting auto_whitelist_path within /etc/mail/spamassassin/local.cf ..."
if [ "`grep auto_whitelist_path /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "auto_whitelist_path /etc/mail/spamassassin/auto-whitelist/db" >> /etc/mail/spamassassin/local.cf || exit 1
fi

echo "Setting use_bayes to 0 within /etc/mail/spamassassin/local.cf ..."
if [ "`grep use_bayes /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "use_bayes 0" >> /etc/mail/spamassassin/local.cf || exit 1
fi


#########################################
# MOVING SPAM TO A SUBFOLDER BY DEFAULT #
#########################################
# If you want this the default behavior:
echo -n "Do you want spams moved to a sub-folder named Spam by default? [Y/n] "
read in MOVE_SPAM
if [ "$MOVE_SPAM" = "Y" -o "$MOVE_SPAM" = "y" -o "$MOVE_SPAM" = "" ] ; then
    echo "Setting default move action in /etc/mail/spamassassin/local.cf ..."
    echo "add_header spam Move-Mail YES" >> /etc/mail/spamassassin/local.cf || exit 1
else
    echo "OK, no default move action"
fi

######################################
# SETTING UP SPAMASSASSIN WITH MYSQL #
######################################
# now we will make SA look for the user preferences in a MySQL database

# as we now also store a sensitive password in local.cf, we need to
echo "Changing ownership of /etc/mail/spamassassin/local.cf to root:spamd ..."
chown root:spamd /etc/mail/spamassassin/local.cf || exit 1

echo "Setting permissions of /etc/mail/spamassassin/local.cf to 640 ..."
chmod 640 /etc/mail/spamassassin/local.cf || exit 1


# the table sa_userspref was already contained in the mailusers.sql file we piped into mysql priviously

echo "Setting options in within /etc/mail/spamassassin/local.cf:"
echo "Setting user_scores_dsn ..."
if [ "`grep user_scores_dsn /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "user_scores_dsn DBI:mysql:mailusers:localhost" >> /etc/mail/spamassassin/local.cf || exit 1
fi

echo "Setting user_scores_sql_username ..."
if [ "`grep user_scores_sql_username /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "user_scores_sql_username mailusers" >> /etc/mail/spamassassin/local.cf || exit 1
fi

echo "Setting user_scores_sql_password ..."
if [ "`grep user_scores_sql_password /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "user_scores_sql_password $MYSQL_MAILUSERS_PWD" >> /etc/mail/spamassassin/local.cf || exit 1
fi

echo "Setting user_scores_sql_custom_query ..."
if [ "`grep user_scores_sql_custom_query /etc/mail/spamassassin/local.cf`" = "" ] ; then
    echo "user_scores_sql_custom_query \
(SELECT preference, value FROM sa_domainpref WHERE domain = _DOMAIN_) \
UNION ALL \
(SELECT preference, value FROM sa_userpref WHERE username = _USERNAME_)" >> /etc/mail/spamassassin/local.cf || exit 1
fi

# if you do not just need default damain preferences and userpreferences,
# you can use the following SQL statement instead:
# (SELECT preference, value FROM sa_domainpref WHERE domain = _DOMAIN_)
# UNION ALL
# (SELECT preference, value FROM sa_userpref WHERE username = _USERNAME_)
# UNION ALL
# (SELECT preference, value FROM sa_domainpref_master WHERE domain = _DOMAIN_)
# UNION ALL
# (SELECT preference, value FROM sa_globalpref_master)
#
# It would allow for
#  - domain default preferences
#  - user preferences that overwrite the domain default preferences
#  - domain master preferences that overwrite the user preferences
#  - global master preferences that overwrite everything
# But as most sites do not need that granularity the
# sa_domainpref_master and sa_globalpref_master tables
# are commented out by default in the $INSTALL_DIR/mailusers.sql file.
########################################################

# restart spamd
echo "Restarting spamdctl ..."
spamdctl restart
sleep 3

echo "Please verify successful startup (output of 'spamdctl stat' follows):"
spamdctl stat
echo -n "Hit ENTER to confirm a successful startup:"
read in;

# make sure spamd can write to the db file
echo "Setting ownership for /etc/mail/spamassassin/auto-whitelist/db to spamd:spamd ..."
chown spamd:spamd /etc/mail/spamassassin/auto-whitelist/db || exit 1

## - ##############################
echo "CONGRATULATIONS! SpamAssassin was successfully installed."
