#!/bin/bash

#################################
# VARIABLES USED IN THIS SCRIPT #
#################################
export HOME_DIR=`(cd $(dirname $0); pwd)`
export PACKAGES_DIR=$HOME_DIR/packages
export PERL_MODULES_DIR=$HOME_DIR/packages/perl_modules
export EXTRACT_DIR=$HOME_DIR/packages_extracted
export PATCHES_DIR=$HOME_DIR/patches
export SCRIPTS_DIR=$HOME_DIR/scripts
export TESTS_DIR=$HOME_DIR/tests
export TMP_DIR=$HOME_DIR/tmp

. $HOME_DIR/install.conf || exit 1

### FUNCTIONS ###

checkRPM()
{
    local PKG="$1"
    echo "Checking for $PKG ..."
    rpm -q $PKG 2>/dev/null >&2;ret=$?
    if [ $ret -ne 0 ] ; then
        echo "ERROR: Could not find $PKG!"
        echo -n "Are you really sure it's installed? [y/N]: "
        read in
        if [ "$in" != "y" -a "$in" != "Y" -a "$in" != "Yes" -a "$in" != "yes" ] ; then
            exit 1
        fi
    fi
}

checkRPMAlternative()
{
    local PKG1="$1"
    local PKG2="$2"
    echo "Checking if $PKG1 or $PKG2 is installed ..."
    rpm -q $PKG1 2>/dev/null >&2;ret1=$?
    rpm -q $PKG2 2>/dev/null >&2;ret2=$?
    if [ $ret1 -ne 0 -a $ret2 -ne 0 ] ; then
        echo "ERROR: Could not find $PKG1 or $PKG2!"
        echo -n "Are you really sure one of them is installed? [y/N]: "
        read in
        if [ "$in" != "y" -a "$in" != "Y" -a "$in" != "Yes" -a "$in" != "yes" ] ; then
            exit 1
        fi
    fi
}
