#!/bin/sh

TMPDIR=/usr/local/qmail-qfilter-tmp
LOGFILE=/var/log/qmail-qfilter-clamdscan.err

#echo `date +"%F %T %z"` Operation started >> $LOGFILE

#
# run clamd as clamd user
# this script runs as qmaild
#

TMPFILE=`mktemp -q $TMPDIR/$$.XXXXXX`;ret=$?

if [ $ret -ne 0 ]; then
	echo `date +"%F %T %z"` mktemp failed with $ret >> $LOGFILE
	exit 1
fi


cat - > $TMPFILE

chmod 644 $TMPFILE

#echo `date +"%F %T %z"` PID $$: Calling clamdscan >> $LOGFILE
/usr/local/bin/clamdscan --quiet $TMPFILE;CLAMRET=$?
#echo `date +"%F %T %z"` PID $$: clamdscan returned $CLAMRET >> $LOGFILE

if [ $CLAMRET -eq 0 ] ; then
	# NO VIRUS
	cat $TMPFILE
	rm -f $TMPFILE
	exit 0
elif [ $CLAMRET -eq 1 ] ; then
	# VIRUS
	rm -f $TMPFILE
	exit 31
elif [ $CLAMRET -eq 2 ] ; then
	# CLAMDSCAN ERROR
	echo `date +"%F %T %z"` clamdscan failed with 2 >> $LOGFILE
	rm -f $TMPFILE
	exit 1
else
	# some other error that should never happen; run out of mem?
	echo `date +"%F %T %z"` "clamdscan FAILED with $CLAMRET - something seriously wrong [smtpdmemorylimit?]" >> $LOGFILE
fi
rm -f $TMPFILE
exit 1

